#version 130
#extension GL_EXT_gpu_shader4 : enable
// the version and open GL extension
// should be the first line of the shader
/////////////////////////////////////////////////////////////////////////////////
//snowflake's chance in hellMod01.fsh     by   pb  
//https://www.shadertoy.com/view/3cBGWy
//Licence : Creative Commons Attribution-ShareAlike 4.0
//http://creativecommons.org/licences/by-sa/4.0
// Adapted, trivialy, for use in VGHD player
/////////////////////////////////////////////
uniform float u_Elapsed;    // The elapsed time in seconds
uniform vec2  u_WindowSize; // Window dimensions in pixels

#define iTime u_Elapsed*0.1666
#define iResolution u_WindowSize

//#define mouse AUTO_MOUSE
//#define MOUSE_SPEED vec2(vec2(0.5,0.577777) * 0.25)
//#define MOUSE_POS   vec2((1.0+cos(iTime*MOUSE_SPEED))*u_WindowSize/2.0)
//#define MOUSE_PRESS vec2(0.0,0.0)
//#define AUTO_MOUSE  vec4( MOUSE_POS, MOUSE_PRESS )
//#define RIGID_SCROLL
// alternatively use static mouse definition
#define iMouse vec4(0.0,0.0, 0.0,0.0)
//#define iMouse vec4(512,256,180,120)
uniform sampler2D texture0;
uniform sampler2D texture1;
uniform sampler2D texture2;
uniform sampler2D texture3;
vec4 texture2D_Fract(sampler2D sampler,vec2 P) {return texture2D(sampler,fract(P));}
vec4 texture2D_Fract(sampler2D sampler,vec2 P, float Bias) {return texture2D(sampler,fract(P),Bias);}
#define texture2D texture2D_Fract

//philip.bertani@gmail.com

float numOct  = 6.,focus = 0.,focus2 = 0.;
vec2 fuv;

float random(vec2 p) {
    return fract( sin( dot( p, vec2(12., 90.)))* 1e6 );
}

mat2 rot2(float an){float cc=cos(an),ss=sin(an); return mat2(cc,-ss,ss,cc);}

float noise(vec3 p) {
    vec2 i = floor(p.yz);
    vec2 f = fract(p.yz);
    float a = random(i + vec2(0.,0.));
    float b = random(i + vec2(1.,0.));
    float c = random(i + vec2(0.,1.));
    float d = random(i + vec2(1.,1.));
    vec2 u = f*f*(3.-2.*f); 
    
    return mix( mix(a,b,u.x), mix(c,d,u.x), u.y);
}

float fbm3d(vec3 p) {
    float v = 0.;
    float a = .5;
    vec3 shift = vec3(focus - focus2); 
    shift.xy += fuv;
    
    float angle = atan(fuv.x,fuv.y);   
    shift.z += angle*10.;

    for (float i=0.; i<numOct; i++) {
        v += a * noise(p);
        p.xz = rot2(angle)*p.xz ;
        p = 2.*p + shift;
        a *= .2*(1.+focus+focus2+.2*length(fuv));  
    }
    return v;
}

vec2 fractal(vec2 z, float param) {
    
    float i=0., mm=.95, too_small=.1;
    
    z *= 1.2*rot2(iTime/3.);
    
    for (; i<6.; i++) {
    
        float x2 = z.x*z.x;
        float y2 = z.y*z.y;
                        
        float z3_re = x2*z.x - 3.0*z.x*y2;
        float z3_im = -y2*z.y + 3.0*x2*z.y;
        float z3_modsq = max(z3_re*z3_re + z3_im*z3_im, too_small);

        vec2 v = vec2( z3_re, z3_im );
        
        z = (1.-mm)*abs(v)
            + mm*abs(v)/z3_modsq  
            + vec2(-1.6,0);
            
    }
    return z;
}

//void mainImage( out vec4 fragColor, in vec2 fragCoord )
///////////////////////////////////////////////////////////////////////////////// 
// need to convert this from a void to a function and call it by adding
// a void main(void) { to the end of the shader
// what type of variable will the function return?, it is a color and needs to be a vec4
// change void to vec4 
//void MainImage(out vec4 fragColor, in vec2 fragCoord) 
vec4 mainImage( out vec4 fragColor, in vec2 fragCoord )
{ 

    vec2 uv = (2.*fragCoord-iResolution.xy)/iResolution.y *.9;

    float aspectRatio = iResolution.x / iResolution.y ;

    vec3 rd = normalize( vec3(uv, -1.5) );  
    vec3 ro = vec3(0,0,2); 
    
    float delta = iTime /2. ; 
        
    rd.yz *= rot2(-delta*1.3 );
    rd.xz *= rot2(delta*3.2);
    vec3 p = ro + rd;

    float bass = 1.8 + .8 * sin(iTime);
    
    vec2 nudge = aspectRatio*vec2( cos(iTime/2.), sin(iTime/2.) );

    fuv = fractal(uv,p.z);
    focus = length(uv + nudge);
    focus = 1.8/(1.+focus) * bass;

    focus2 = length(uv - nudge);
    
    focus2 = 4.5/(1.+focus2*focus2) / bass;

    vec3 q = vec3( fbm3d(p), fbm3d(p.yzx), fbm3d(p.zxy) ) ;

    float f = fbm3d(p + q);
    
    vec3 cc = q;
    cc *= 20.*f;   

    cc.r += 4.5*focus; cc.g+= 2.*focus; 
    cc.b += 7.*focus2; cc.r-=3.5*focus2; 
   
    cc /= 20.;
    
    fragColor = vec4( cc,1.0);
    
//////////////////////////////////////////////////////////////////////////////
//the function needs to return a value. 
//it needs to be a vec4
//we will return the varable fragColor 
// usual place for fragColor = vec4( color, 1.0 ); bring the } down below 
return fragColor; 
}

///////////////////////////////////////////////////////////////////////////////// 
void main(void) { // this will be run for every pixel of gl_FragCoord.xy
vec4 vTexCoord = gl_TexCoord[0];
vec4 fragColor = vec4(1.0); // initialize variable fragColor as a vec4 
vec4 cc = mainImage(fragColor, gl_FragCoord.xy); // call function mainImage and assign the return vec4 to cc
gl_FragColor = vec4(cc) * gl_Color; // set the pixel to the value of vec4 cc  and..
//gl_FragColor.a = length(gl_FragColor.rgb);
}

// ..uses the values of any Color: or Opacity:
// clauses (and any Animate clauses applied to these properties) 
// appearing in the Sprite, Quad or other node invoking the shader 
// in the .scn file.

